﻿<?LassoScript

	// Styled Nametags demo for Lasso Summit 2007
	// Author Jolle Carlestam
	// Inspired by a TOTW example creating Mailing Labels by Fletcher Sandbeck 2004
	// Use and alter freely but please keep this info




	// Preparation of demo content. This should be replaced with your 
	// own record content handling.
	// the demo assumes that the files ex_cont/Contacts.incl, 
	// ex_cont/jina_prepPDF_demo.incl and ex_cont/Bkgr2_name_tags_Summit.jpg
	// are in the same folder and can be accessed by Lasso
	Include:'ex_cont/jina_prepPDF_demo.incl';
	var:'allData' = jina_prepContacts: (Include:'ex_cont/Contacts.incl');


	// For testing purposes rectangles are drawn on the nametags sheet.
	// Use this variable to turn these rectangles off for actual nametag printing.
	var: 'drawRects' = false;

	// If you only want the first page while testing set this to true
	var:'firstPageonly' = true;

	//#################################################################################//
	// Settings that control the look and layout of the nametag sheets.
	// These demo settings are suitable for an A4 page with 2 cols 4 rows

	// Image used as background for each nametag.
	// Real image size should be at least twice the nametag width and height.
	// That is if nametag width is 273 and height is 173 then
	// image size should be 546 * 346.
	var:'bkgrImage' = (PDF_Image:-file = 'ex_cont/Bkgr2_name_tags_Summit.jpg');	

	// Heading displayed on every nametag.
	var:'headingText' = 'Lasso Summit 2007';

	// The number of rows and columns of nametags
	var:'nameTagRows' = 4;
	var:'nameTagCols' = 2;


	// These variables set the font face and leading
	var:'headingFont' = (pdf_font: -face = 'Helvetica-Bold', -size = 14, -color = '#FFFFFF');
	var:'titleFont' = (pdf_font: -face = 'Helvetica-Bold', -size = 14, -color = '#e9a45f');
	var:'nameFont' = (pdf_font: -face = 'Helvetica-Bold', -size = 20, -color = '#e9a45f');
	var:'orgFont' = (pdf_font: -face = 'Helvetica-Bold', -size = 18, -color = '#e9a45f');
	var:'cityFont' = (pdf_font: -face = 'Helvetica-Bold', -size = 14, -color = '#FFFFFF');
	var:'titleLeading' = 16;
	var:'nameLeading' = 22;
	var:'orgLeading' = 20;
	var:'cityLeading' = 20;

	var:'pageSize' = 'A4';
	var:'pageHeight' = 842;

	// The top and left margin for the page (where the upper left nametag is located), in points
	var:'marginTop' = 45;
	var:'marginLeft' = 25;
	
	// The width and height of each nametag
	var:'nameTagWidth' = 273;
	var:'nameTagHeight' = 173;
	
	// The width between nametag columns and height between nametag rows (if any).
	var:'marginWidth' = 0;
	var:'marginHeight' = 0;

	// If text needs vertical adjustment to fit with background
	var:'verticalAdjust' = -15;

	// Setting a default country that will not show up on the nametags. All other countries will.
	var:'defaultCountry' = 'USA';

	//#################################################################################//

	// Vars set to be used by the application. Do not change these.
	var:'newPageCheck' = $nameTagRows * $nameTagCols;
	var:'nameTagData' = array;
	var:'nameTagArray' = array;
	var:'nameTagTemp' = string;
	var:'titleTag' = string;
	var:'nameTag' = string;
	var:'orgTag' = string;
	var:'cityTag' = string;
	var:'prepNameTag' = string;
	var:'titleVerSize' = integer;
	var:'nameVerSize' = integer;
	var:'orgVerSize' = integer;
	var:'cityVerSize' = integer;
	var:'nameTagVerSize' = integer;
	var:'colPos' = integer;
	var:'rowCount' = integer;
	var:'nameTagLeft' = integer;
	var:'nameTagTop' = integer;
	var:'tempNameTagTop' = integer;

	
	// Create the PDF file.
	var:'pdfTemplate' = (pdf_doc:
		-nocompress,
		-size = $pageSize,
		-title = 'nametags',
		-author = 'jinaOnline',
		-margins = (array: 0,0,0,0)
		);

	$pdfTemplate->(setcolor: 'stroke', 'rgb', .05, .75, .75);

	// Iterate all contacts. This would probably be a Records container in the real world
	iterate: $allData, $nameTagData; // $nameTagData now holds all info for one contact in an array

		if:($rowCount) == $nameTagRows; // Time to move one column and reset nametag row
			$colPos += 1;
			$rowCount = 0;
		/if;

		// Set this nametags position.
		$nameTagLeft = $marginLeft + (($nameTagWidth + $marginWidth) * $colPos);
		$nameTagTop = $marginTop + (($nameTagHeight + $marginHeight) * $rowCount);

		$rowCount += 1;

		$pdfTemplate->(Add:$bkgrImage,
			-left = $nameTagLeft,
			-top = $nameTagTop + $nameTagHeight,
			-height = $nameTagHeight,
			-width = $nameTagWidth);

		if: $drawRects; // Adjusted for graphic coordinates starting at lower left.
			$pdfTemplate->(rect: $nameTagLeft,
				($pageHeight - $nameTagTop - $nameTagHeight),
				$nameTagWidth,
				$nameTagHeight);
		/if;

		$pdfTemplate->(Add: (PDF_Text: $headingText,
				-type = 'paragraph', -font = $headingFont),
			-width = $nameTagWidth - 12,
			-left = $nameTagLeft + 16,
			-top = $nameTagTop + 3,
			-align = 'left');

		$titleTag = jina_prepTitle: $nameTagData; // $titleTag holds an eventual title of the contact.
		$nameTag = jina_prepName: $nameTagData; // $nameTag holds the name of the contact.
		$orgTag = jina_prepOrg: $nameTagData; // $orgTag holds the organisation of the contact.
		$cityTag = (jina_prepCity: $nameTagData, $defaultCountry); // $cityTag holds the city (and eventual Country) of the contact.


		// Calculate the vertical space within the nametag that this content will occupy.

		// First checking the title.
		if:$titleTag->Size > 0;
			$nameTagArray = $titleTag->(split:'\r');

			$titleVerSize = $nameTagArray->Size; // This gives us all hardcoded line feeds. There shouldn't be any, but you never know.

			iterate:  $nameTagArray, $nameTagTemp;
				// This adds rows if the content flows over more than one row .
				$titleVerSize += math_floor(($titleFont->(textwidth: $nameTagTemp)) / ($nameTagWidth - 12));
			/iterate;

			$titleVerSize *= $titleLeading;

		else;
			$titleVerSize = integer;
		/if;

		// Then checking the name
		$nameTagArray = $nameTag->(split:'\r');
		
		$nameVerSize = $nameTagArray->Size; // This gives us all hardcoded line feeds. There shouldn't be any, but you never know.

		iterate:  $nameTagArray, $nameTagTemp;
			// This adds rows if the content flows over more than one row.
			$nameVerSize += math_floor(($nameFont->(textwidth: $nameTagTemp)) / ($nameTagWidth - 12));
		/iterate;

		$nameVerSize *= $nameLeading;

		// Then checking the org
		if:$orgTag->Size > 0;
			$nameTagArray = $orgTag->(split:'\r');

			$orgVerSize = $nameTagArray->Size; // This gives us all hardcoded line feeds. There shouldn't be any, but you never know.

			iterate:  $nameTagArray, $nameTagTemp;
				// This adds rows if the content flows over more than one row.
				$orgVerSize += math_floor(($orgFont->(textwidth: $nameTagTemp)) / ($nameTagWidth - 12));
			/iterate;

			$orgVerSize *= $orgLeading;
		else;
			$orgVerSize = integer;
		/if;

		// Then checking the city
		if:$cityTag->Size > 0;
			$nameTagArray = $cityTag->(split:'\r');

			$cityVerSize = $nameTagArray->Size; // This gives us all hardcoded line feeds. There shouldn't be any, but you never know.

			iterate:  $nameTagArray, $nameTagTemp;
				// This adds rows if the content flows over more than one row.
				$cityVerSize += math_floor(($cityFont->(textwidth: $nameTagTemp)) / ($nameTagWidth - 12));
			/iterate;

			$cityVerSize *= $cityLeading;
		else;
			$cityVerSize = integer;
		/if;
		$nameTagVerSize = $titleVerSize + $nameVerSize + $orgVerSize + $cityVerSize;
		$tempNameTagTop = $nameTagTop + (($nameTagHeight - $nameTagVerSize) / 2) + $verticalAdjust;


		// Time to add this nametag content to the pdf.

		$pdfTemplate->(Add: (PDF_Text: $titleTag,
				-type = 'paragraph', -font = $titleFont),
			-width = $nameTagWidth - 12,
			-left = $nameTagLeft + 6,
			-top = $tempNameTagTop,
			-align = 'center', 
			-leading = $titleLeading);

		$tempNameTagTop += $titleVerSize;
		$pdfTemplate->(Add: (PDF_Text: $nameTag,
				-type = 'paragraph', -font = $nameFont),
			-width = $nameTagWidth - 12,
			-left = $nameTagLeft + 6,
			-top = $tempNameTagTop,
			-align = 'center', 
			-leading = $nameLeading);

		$tempNameTagTop += $nameVerSize;
		$pdfTemplate->(Add: (PDF_Text: $orgTag,
				-type = 'paragraph', -font = $orgFont),
			-width = $nameTagWidth - 12,
			-left = $nameTagLeft + 6,
			-top = $tempNameTagTop,
			-align = 'center', 
			-leading = $orgLeading);

		$tempNameTagTop += $orgVerSize;
		$pdfTemplate->(Add: (PDF_Text: $cityTag,
				-type = 'paragraph', -font = $cityFont),
			-width = $nameTagWidth - 12,
			-left = $nameTagLeft + 6,
			-top = $tempNameTagTop,
			-align = 'center', 
			-leading = $cityLeading);

		if:loop_count % $newPageCheck == 0; // Time for a new page. Reset counters.
			(($firstPageonly) ? loop_abort);
			$colPos = integer;
			$rowCount = integer;

			$pdfTemplate->AddPage;
		/if;

	/iterate;

// Serve the PDF.
	$pdfTemplate->close;
	pdf_serve: -content = $pdfTemplate, -file = 'Jina Demo Nametags.pdf';


?>